<?php
/**
 * Plugin Name: Hugeicons
 * Description: The official Hugeicons WordPress plugin. Access both Free and Pro icon libraries, with easy integration for your website. Brought to you by the Hugeicons team.
 * Version: 1.0.0
 * Author: Hugeicons
 * Author URI: https://hugeicons.com
 * Text Domain: hugeicons
 * License: GNU General Public License v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

if (!defined('ABSPATH')) {
	exit;
}

// Define plugin constants
define('HUGEICONS_VERSION', '1.0.0');
define('HUGEICONS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('HUGEICONS_PLUGIN_URL', plugin_dir_url(__FILE__));

// Autoload classes
spl_autoload_register(function ($class) {
	$prefix = 'Hugeicons\\';
	$base_dir = HUGEICONS_PLUGIN_DIR . 'includes/';

	$len = strlen($prefix);
	if (strncmp($prefix, $class, $len) !== 0) {
		return;
	}

	$relative_class = substr($class, $len);
	$file = $base_dir . 'class-' . strtolower(str_replace('_', '-', $relative_class)) . '.php';

	if (file_exists($file)) {
		require $file;
	}
});

// Initialize the plugin
function hugeicons_init() {
	$loader = new Hugeicons\Loader();
	$loader->init();
}

add_action('plugins_loaded', 'hugeicons_init');