<?php get_header(); ?>

<main class="single-post-layout container">

  <?php if (get_post_type() === 'post'): // Only for blog posts ?>

    <!-- Header Articol -->
    <header class="post-header">
      <h1 class="post-title"><?php the_title(); ?></h1>
      <p class="post-subtitle"><?php echo get_the_excerpt(); ?></p>
    </header>

  <?php endif; ?>

  <!-- Imagine Erou -->
  <?php if (has_post_thumbnail()): ?>
    <figure class="post-thumbnail">
      <?php the_post_thumbnail('large'); ?>

      <div class="post-thumbnail-footer">
        <div class="post-meta">
          <p class="post-date">
            <i class="hgi hgi-stroke hgi-clock-02"></i>
            <?php echo get_the_date('j F Y'); ?>
          </p>
          <p class="post-category"><?php the_category(', '); ?></p>
        </div>

        <div class="post-share">
          <!-- Copy Link -->
          <button class="copy-link-btn" onclick="copyPostLink(this)">
            <i class="hgi hgi-stroke hgi-copy-01"></i> 
            <span>Copiază link-ul</span>
          </button>

          <!-- Share Buttons -->
          <div class="share-icons">
            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank"
              title="Share on Facebook"><i class="hgi hgi-stroke hgi-facebook-02"></i></a>
            <a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" target="_blank" title="Share on X"><i
                class="hgi hgi-stroke hgi-new-twitter"></i></a>
            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>" target="_blank"
              title="Share on LinkedIn"><i class="hgi hgi-stroke hgi-linkedin-02"></i></a>
          </div>
        </div>
      </div>
    </figure>
  <?php endif; ?>

  <!-- Structură cu TOC + conținut -->
  <div class="post-body-grid">
    <!-- Conținut articol -->
    <div class="post-content">
      <?php while (have_posts()):
        the_post(); ?>
        <?php the_content(); ?>
      <?php endwhile; ?>

      <?php if (get_post_type() === 'post'): ?>
        <div class="post-navigation">
          <div class="prev-post">
            <?php previous_post_link('%link', '<i class="hgi hgi-stroke hgi-arrow-left-02"></i> <span>Articolul anterior</span>'); ?>
          </div>
          <div class="next-post">
            <?php next_post_link('%link', '<span>Articolul următor</span> <i class="hgi hgi-stroke hgi-arrow-right-02"></i>'); ?>
          </div>
        </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- Comentarii -->
  <section class="comments-section">
    <?php comments_template(); ?>
  </section>

  <?php if (get_post_type() === 'post'): // Only for blog posts ?>
    <!-- Articole Asemănătoare -->
    <section class="related-posts">
      <h2>Articole asemănătoare</h2>
      <span class="separator"></span>

      <div class="swiper related-swiper">
        <div class="swiper-wrapper">
          <?php
          $related = new WP_Query([
            'posts_per_page' => 3,
            'post__not_in' => [get_the_ID()],
            'category__in' => wp_get_post_categories(get_the_ID())
          ]);
          if ($related->have_posts()):
            while ($related->have_posts()):
              $related->the_post(); ?>
              <div class="swiper-slide">
                <article class="related-card">
                  <div class="card-header">
                    <?php the_post_thumbnail('medium'); ?>
                    <div class="meta">
                      <p>
                        <i class="hgi hgi-stroke hgi-clock-02"></i>
                        <?php echo get_the_date(); ?>
                      </p>
                      <?php the_category(', '); ?>
                    </div>
                  </div>
                  <h3><?php the_title(); ?></h3>
                  <p class="excerpt"><?php echo wp_trim_words(get_the_excerpt(), 15); ?></p>
                  <a href="<?php the_permalink(); ?>" class="btn-read">Citește postarea <i
                      class="hgi hgi-stroke hgi-arrow-right-02"></i></a>
                </article>
              </div>
            <?php endwhile;
            wp_reset_postdata();
          endif; ?>
        </div>
        <div class="swiper-pagination"></div>
      </div>
    </section>

    <!-- Newsletter CTA -->
    <section class="newsletter-section">
      <div class="newsletter-text">
        <h4>Abonează-te la newsletter</h4>
        <p>Primește cele mai recente articole, povești și sfaturi direct în inbox-ul tău.
          <br/>
          Nu rata nimic din ce e important!</p>
      </div>
      <?php echo do_shortcode('[newsletter_form]'); ?>
    </section>
  <?php endif; ?>

</main>

<?php get_footer(); ?>